Attribute VB_Name = "MdlMain"
Option Explicit

Declare Sub Sleep Lib "KERNEL32.DLL" (ByVal dwMilliseconds As Long)

'*********
'  
'*********
Private Function Limit_Chk(frq As Double, lvl As Double, lim As FreqLvl_Limit) As Boolean
    
    With lim
        If .intUpFreqChk Then
            If .UpFreq < frq Then Limit_Chk = False: Exit Function
        End If
        If .intLwFreqChk Then
            If .LwFreq > frq Then Limit_Chk = False: Exit Function
        End If
        If .intLwLvlChk Then
            If .LwLevel > lvl Then Limit_Chk = False: Exit Function
        End If
        If .intUpLvlChk Then
            If .UpLevel < lvl Then Limit_Chk = False: Exit Function
        End If
    End With
    
    Limit_Chk = True
End Function

'*****************
'  SWRg`MaxZo
'*****************
Public Sub QryFetcSwrPMax(ByVal msrCh As Long, ByVal sta As Long, ByVal sto As Long, ByRef sngSwr As Double, ByRef SwrF As Double, ByRef SwrP As Long)
    Dim po As Long
    
    sngSwr = BufSwr(sta, msrCh)
    SwrP = sta
    For po = sta To sto
        If sngSwr < BufSwr(po, msrCh) Then
            sngSwr = BufSwr(po, msrCh)
            SwrP = po
        End If
    Next po
    SwrF = BufFrq(SwrP, msrCh)
End Sub

'*****************
'  SWRg`MinZo
'*****************
Public Sub QryFetcSwrPMin(ByVal msrCh As Long, ByVal sta As Long, ByVal sto As Long, ByRef sngSwr As Double, ByRef SwrF As Double, ByRef SwrP As Long)
    Dim po As Long
    Dim swr_min As Single
    
    sngSwr = BufSwr(sta, msrCh)
    SwrP = sta
    For po = sta To sto
        If BufSwr(po, msrCh) < sngSwr Then
            sngSwr = BufSwr(po, msrCh)
            SwrP = po
        End If
    Next po
    SwrF = BufFrq(SwrP, msrCh)
End Sub

'*****************
'  SWRg`Zo
'*****************
Private Sub get_Swr(ByVal msrCh As Long, ByVal sta As Long, ByVal sto As Long)
    Dim po As Long
    Dim swr As Single
    
    For po = sta To sto
        If BufLnm(po, msrCh) = 1 Then
            swr = 10000000000000#   'Error Data
        Else
            swr = Abs((1 + BufLnm(po, msrCh)) / (1 - BufLnm(po, msrCh)))
        End If
        BufSwr(po, msrCh) = swr

        With ChInfo(msrCh).Trace
            If po = 0 Then
                .MinSwr = swr: .MaxSwr = swr
                .MinPSwr = po: .MaxPSwr = po
            Else
                If .MinSwr > swr Then
                    .MinSwr = swr
                    .MinPSwr = po
                End If
                If swr > .MaxSwr Then
                    .MaxSwr = swr
                    .MaxPSwr = po
                End If
            End If
        End With
    Next

End Sub

'*****************
'  CH؂ւ
'*****************
Public Function meas_ch(MeasCh As Long) As Long
    Dim lngErr As Long
    Dim tmp As Long
    
    lngErr = BisPioOut(lngPID, ChInfo(MeasCh).Pio)      'pI/Oo
    If lngACh = MeasCh Then meas_ch = lngErr: Exit Function
    lngACh = MeasCh
    lngErr = BisMeasAct(lngPID, MeasCh + 1)
    lngErr = QrySensFunc(lngPID, tmp)                   'Dummy Meas read
    lngErr = BisSensFunc(lngPID, tmp)
    
    meas_ch = lngErr
End Function


'***********
' Meas\
'***********
Public Sub meas_opt_disp(frm As frmCH, ByVal inpm As Long)
    Dim i As Integer
    
    ' Input Measure
    If 0 < InStr(NA_ProductName, "R3760") Then
        If inpm = McrMeasS21 Then
            frm.lbl_msr.Caption = "S21"
            frm.Option_msr(McrMeasS21).Value = True
        ElseIf inpm = McrMeasS11 Then
            frm.lbl_msr.Caption = "S11"
            frm.Option_msr(McrMeasS11).Value = True
        ElseIf inpm = McrMeasS12 Then
            If lngExpSwBox <> SWBOX_DPDT Then
                frm.lbl_msr.Caption = "S21"
                frm.Option_msr(McrMeasS21).Value = True
            Else
                frm.lbl_msr.Caption = "S12"
                frm.Option_msr(McrMeasS12).Value = True
            End If
        ElseIf inpm = McrMeasS22 Then
            If lngExpSwBox <> SWBOX_DPDT Then
                frm.lbl_msr.Caption = "S11"
                frm.Option_msr(McrMeasS11).Value = True
            Else
                frm.lbl_msr.Caption = "S22"
                frm.Option_msr(McrMeasS22).Value = True
            End If
        End If
        frm.Option_msr(McrMeas__R).Visible = False
    Else
        If inpm = McrMeas_AR Then
            frm.lbl_msr.Caption = "A/R"
            frm.Option_msr(McrMeas_AR).Value = True
        ElseIf inpm = McrMeas__A Then
            frm.lbl_msr.Caption = "A"
            frm.Option_msr(McrMeas__A).Value = True
        Else
            frm.lbl_msr.Caption = "R"
            frm.Option_msr(McrMeas__R).Value = True
        End If
        frm.Option_msr(McrMeas__R).Visible = True
    End If
End Sub

'**********************
' Meas\Rg[
'**********************
Public Sub meas_disp_ctrl(frm As frmCH)
    With frm
        If 0 < InStr(NA_ProductName, "R3760") Then
            .Option_msr(McrMeas_AR).Visible = False
            .Option_msr(McrMeas__A).Visible = False
            .Option_msr(McrMeasS21).Visible = True
            .Option_msr(McrMeasS11).Visible = True
            If lngExpSwBox = SWBOX_DPDT Then
                .Option_msr(McrMeasS12).Visible = True
                .Option_msr(McrMeasS22).Visible = True
            Else
                .Option_msr(McrMeasS12).Visible = False
                .Option_msr(McrMeasS22).Visible = False
            End If
        Else
            .Option_msr(McrMeas_AR).Visible = True
            .Option_msr(McrMeas__A).Visible = True
            .Option_msr(McrMeasS21).Visible = False
            .Option_msr(McrMeasS11).Visible = False
            .Option_msr(McrMeasS12).Visible = False
            .Option_msr(McrMeasS22).Visible = False
        End If
    End With
End Sub

'*****************
' CH tH[
'*****************
Public Function MeasureChAdd(ini_flg As Integer) As Boolean
    Dim i As Integer
    Dim tmp As Variant
    Dim ChWndHeight As Variant
    Dim ChWndWidth As Variant
    Dim strCh As String
    
    If ChNum > MAX_CH Then MeasureChAdd = False: Exit Function
    
    '*** New CH Wind Obj  ***
    Set frm_CH(ChNum) = New frmCH
    lngACh = ChNum
    intFrmCh(lngACh) = 1
    strCh = TabCapCh & CStr(lngACh + 1)
    frm_CH(lngACh).SSTab_CH.Caption = strCh & TabCapWev
    frm_CH(lngACh).SSTab_CH.Tab = 1
    frm_CH(lngACh).SSTab_CH.Caption = TabCapSet
    frm_CH(lngACh).SSTab_CH.Tab = 2
    frm_CH(lngACh).SSTab_CH.Caption = TabCapMsr
    frm_CH(lngACh).SSTab_CH.Tab = 0
    frm_CH(lngACh).Caption = strCh
    For i = 1 To frmCH.Text_stm.UBound
        frm_CH(lngACh).Text_stm(i) = frmCH.Text_stm(i).Text
    Next i
    
    ' ChInfo(lngACh).WaveFrmt ̕ϐ̏L̏Ō˂
    If ini_flg Then frm_CH(lngACh).Check_Format(FmtTypeLogMg).Value = 1
    
    With ChInfo(lngACh)
        .TrLgm = 1024 * lngACh + BIS_TRAC1_LOGMAG
        .TrPhs = 1024 * lngACh + BIS_TRAC1_PHASE
        .TrLnm = 1024 * lngACh + BIS_TRAC1_LINMAG
        .TrRel = 1024 * lngACh + BIS_TRAC1_UDT_RE
        .TrImg = 1024 * lngACh + BIS_TRAC1_UDT_IM
        .TrCa1 = 1024 * lngACh + BIS_TRAC1_CAL1
        .TrCa2 = 1024 * lngACh + BIS_TRAC1_CAL2
        .TrCa3 = 1024 * lngACh + BIS_TRAC1_CAL3
        If ini_flg Then
            With .Trace
                .Mscl.ref = 0: .Mscl.div = 10: .Mscl.pos = 100
                .Pscl.ref = 0: .Pscl.div = 45: .Pscl.pos = 50
                .Dscl.ref = 0: .Dscl.div = 100 * Unit_n: .Dscl.pos = 50
                .SWRscl.ref = 1: .SWRscl.div = 1: .SWRscl.pos = 0
                .Rscl.ref = 0: .Rscl.div = 1: .Rscl.pos = 50
                .Iscl.ref = 0: .Iscl.div = 1: .Iscl.pos = 50
            End With
        End If
    End With
    
    If RdCsvInfo.ChNum <= 2 Then
        ChWndHeight = (MDIfrmMain.Height - intfrmCHTopOfst) / RdCsvInfo.ChNum - (10 * RdCsvInfo.ChNum)    'File Setting
        ChWndWidth = MDIfrmMain.Width - frmMain.Width - intfrmCHLeftOfst
    Else
        ChWndHeight = (MDIfrmMain.Height - intfrmCHTopOfst) / 2 - (10 * 2)    'File Setting
        ChWndWidth = (MDIfrmMain.Width - frmMain.Width - intfrmCHLeftOfst + 60) / 2 - (10 * 2)     'File Setting
    End If
    
    For i = 0 To ChNum
        frm_CH(i).Height = ChWndHeight
        frm_CH(i).Width = ChWndWidth
    Next i

    If RdCsvInfo.ChNum = 1 Or RdCsvInfo.ChNum = 2 Then  '2CHݒȉ
        frm_CH(ChNum).Top = ChWndHeight * ChNum
        frm_CH(ChNum).Left = 0
    Else                                                '3CHݒȏ
        If ChNum = 0 Or ChNum = 2 Then
            frm_CH(ChNum).Left = 0
            If ChNum = 0 Then
                frm_CH(ChNum).Top = 0
            Else
                frm_CH(ChNum).Top = ChWndHeight
            End If
        ElseIf ChNum = 1 Or ChNum = 3 Then
            frm_CH(ChNum).Left = ChWndWidth
            If ChNum = 1 Then
                frm_CH(ChNum).Top = 0
            Else
                frm_CH(ChNum).Top = ChWndHeight
            End If
        End If
    End If

    frm_CH(ChNum).Show
    ChNum = ChNum + 1   '*** o^CH ***

    MeasureChAdd = True
End Function

'************************
' g̃xl
'************************
Private Sub MakeDispFreqResult(ByRef MeasTitle As String, ByRef msdt As struct_measdata, strUnitFmt As String)
    With msdt
        .strDispData = Format(MeasTitle & "  " & Format(.freq_lvl / Unit_mega, MkrfMHzfkHz$) & " ", "@@@@@@@@@@@@@@")  '"No.xx ffff.f "
        .strDispData = .strDispData & Format(Format(.ResData, strUnitFmt), "@@@@@@@@@@")
    End With
End Sub

'****************************
' x|̃xl
'****************************
Private Sub MakeDispLevelResult(ByRef MeasTitle As String, ByRef msdt As struct_measdata, strUnitFmt As String)
    With msdt
        .strDispData = Format(MeasTitle & "  " & Format(.freq_lvl, StrLvlUnit) & " ", "@@@@@@@@@@@@@@")  '"No.xx llll.l "
        .strDispData = .strDispData & Format(Format(.ResData, strUnitFmt), "@@@@@@@@@@")
    End With
End Sub

'*********************************************************************
' w背xzf[^T[`Aw背x̃|CgԂ܂B
' ActCh As Long      : CH
' Pnt As Long        : CH̐ݒ|Cg
' sngLvl As Single   : w背xiT[`xj
' LvlBuf() As Single : T[`zf[^
' lmt_chk As Boolean : zf[^jAEf[^̏ꍇ
'                      őAŏ`FbN^Ȃ
'*********************************************************************
Public Function search_level_point(ActCh As Long, Pnt As Long, sngLvl As Double, ByRef LvlBuf() As Double, lmt_chk As Boolean) As Integer
    Dim i As Integer
    Dim NearFreqPoint As Integer
    Dim tmp1 As Double
    Dim tmp2 As Double
    
    If lmt_chk = True Then
        If sngLvl < LvlBuf(0, ActCh) Then
            search_level_point = 0
            Exit Function
        ElseIf LvlBuf(Pnt - 1, ActCh) < sngLvl Then
            search_level_point = Pnt - 1
            Exit Function
        End If
    End If
    
    For i = 0 To Pnt - 2
        If LvlBuf(i, ActCh) <= sngLvl And sngLvl <= LvlBuf(i + 1, ActCh) Then
            tmp1 = sngLvl - LvlBuf(i, ActCh)
            tmp2 = LvlBuf(i + 1, ActCh) - sngLvl
            If tmp1 < tmp2 Then
                search_level_point = i
            Else
                search_level_point = i + 1
            End If
            Exit For
        End If
    Next i
End Function

'****************
'   
'****************
Public Sub MeasExe(ByVal lngCh As Long, ByVal no As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata, ByRef msfmt As String)
    Dim lngErr As Long
    Dim stf As Double
    Dim spf As Double
    Dim stp As Long
    Dim spp As Long
    Dim vvv As Double
    Dim fff As Double
    Dim ppp As Long
    Dim p1, p2 As Long
    Dim f1, f2 As Double

    On Error GoTo ErrMeas
    Select Case UCase(msfmt)
        Case "LOGMAG":
            With msi
                Select Case .MeasType
                    Case McrMeasMAX
                        lngErr = QryFetcMax(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.freq_lvl, msdt.freqp)
                        If BufFrq(.PStart, lngACh) <> .Start Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                            If .MeasResult < vvv Then .MeasResult = vvv: msdt.freq_lvl = .Start
                        End If
                        If BufFrq(.PStop, lngACh) <> .Stop Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                            If .MeasResult < fff Then .MeasResult = fff: msdt.freq_lvl = .Stop
                        End If
                        msdt.ResData = .MeasResult
                        msdt.ResType = McrFreq
                        msdt.ResCh = lngCh
                        msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                        Call MakeDispFreqResult("No." & Format(no, "00"), msdt, StrLogUnit)
                    Case McrMeasMIN
                        lngErr = QryFetcMin(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.freq_lvl, msdt.freqp)
                        If BufFrq(.PStart, lngACh) <> .Start Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                            If vvv < .MeasResult Then .MeasResult = vvv: msdt.freq_lvl = .Start
                        End If
                        If BufFrq(.PStop, lngACh) <> .Stop Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                            If fff < .MeasResult Then .MeasResult = fff: msdt.freq_lvl = .Stop
                        End If
                        msdt.ResData = .MeasResult
                        msdt.ResType = McrFreq
                        msdt.ResCh = lngCh
                        msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                        Call MakeDispFreqResult("No." & Format(no, "00"), msdt, StrLogUnit)
                    Case McrMeasVAL
                        lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, .MeasResult)
                        msdt.ResData = .MeasResult
                        msdt.ResType = McrFreq
                        msdt.ResCh = lngCh
                        msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                        msdt.freq_lvl = .Start
                        msdt.freqp = .PStart
                        Call MakeDispFreqResult("No." & Format(no, "00"), msdt, StrLogUnit)
                    Case McrMeasPWRVAL
                        ppp = search_level_point(lngCh, ChInfo(lngCh).lngTotP, .Start, BufLvl, True)
                        If BufLvl(ppp, lngCh) <> .Start Then
                            If ppp <> 0 Then
                                If BufLvl(ppp - 1, lngCh) < .Start And .Start < BufLvl(ppp, lngCh) Then ppp = ppp - 1
                            End If
                            f1 = BufLvl(ppp, lngCh)         'x0
                            f2 = BufLvl(ppp + 1, lngCh)     'x1
                            fff = BufLgm(ppp, lngCh)        'y0
                            vvv = BufLgm(ppp + 1, lngCh)    'y1
                            vvv = fff + (.Start - f1) * (vvv - fff) / (f2 - f1) 'y = y0+(x-x0)*(y1-y0)/(x1-x0)
                            .MeasResult = vvv
                        Else
                            .MeasResult = BufLgm(ppp, lngCh)
                        End If
                        msdt.ResData = .MeasResult
                        msdt.ResType = McrLevel
                        msdt.ResCh = lngCh
                        msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                        msdt.freqp = ppp
                        msdt.freq_lvl = .Start
                        Call MakeDispLevelResult("No." & Format(no, "00"), msdt, StrLvlUnit)
                End Select
            End With
        Case "PHASE": msdt.ResData = ERR_VALUE
        Case "POLAR": msdt.ResData = ERR_VALUE
        Case "SMITH": msdt.ResData = ERR_VALUE
        Case "DELAY": msdt.ResData = ERR_VALUE
        Case "SWR":
            With msi
                Select Case .MeasType
                    Case McrMeasMAX
                        Call QryFetcSwrPMax(lngCh, .PStart, .PStop, .MeasResult, msdt.freq_lvl, msdt.freqp)
                        If BufFrq(.PStart, lngACh) <> .Start Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                            If vvv = 1 Then
                                vvv = 10000000000000#   'Error Data
                            Else
                                vvv = Abs((1 + vvv) / (1 - vvv))
                            End If
                            If .MeasResult < vvv Then .MeasResult = vvv: msdt.freq_lvl = .Start
                        End If
                        If BufFrq(.PStop, lngACh) <> .Stop Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                            If fff = 1 Then
                                fff = 10000000000000#   'Error Data
                            Else
                                fff = Abs((1 + fff) / (1 - fff))
                            End If
                            If .MeasResult < fff Then .MeasResult = fff: msdt.freq_lvl = .Stop
                        End If
                        msdt.ResData = .MeasResult
                        msdt.ResType = McrFreq
                        msdt.ResCh = lngCh
                        msdt.ResTrcFmt = WAVE_FORMAT____SWR
                       Call MakeDispFreqResult("No." & Format(no, "00"), msdt, StrSwrUnit)
                   Case McrMeasMIN
                        Call QryFetcSwrPMin(lngCh, .PStart, .PStop, .MeasResult, msdt.freq_lvl, msdt.freqp)
                        If BufFrq(.PStart, lngACh) <> .Start Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                            If vvv = 1 Then
                                vvv = 10000000000000#   'Error Data
                            Else
                                vvv = Abs((1 + vvv) / (1 - vvv))
                            End If
                            If vvv < .MeasResult Then .MeasResult = vvv: msdt.freq_lvl = .Start
                        End If
                        If BufFrq(.PStop, lngACh) <> .Stop Then
                            lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                            If fff = 1 Then
                                fff = 10000000000000#   'Error Data
                            Else
                                fff = Abs((1 + fff) / (1 - fff))
                            End If
                            If fff < .MeasResult Then .MeasResult = fff: msdt.freq_lvl = .Stop
                        End If
                        msdt.ResData = .MeasResult
                        msdt.ResType = McrFreq
                        msdt.ResCh = lngCh
                        msdt.ResTrcFmt = WAVE_FORMAT____SWR
                        Call MakeDispFreqResult("No." & Format(no, "00"), msdt, StrSwrUnit)
                    Case McrMeasVAL
                        lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, .MeasResult)
                        If .MeasResult = 1 Then
                            msdt.ResData = 10000000000000#   'Error Data
                        Else
                            msdt.ResData = Abs((1 + .MeasResult) / (1 - .MeasResult))
                        End If
                        msdt.ResType = McrFreq
                        msdt.ResCh = lngCh
                        msdt.ResTrcFmt = WAVE_FORMAT____SWR
                        msdt.freq_lvl = .Start
                        msdt.freqp = ppp
                        Call MakeDispFreqResult("No." & Format(no, "00"), msdt, StrSwrUnit)
                End Select
            End With
        Case "REAL": msdt.ResData = ERR_VALUE
        Case "IMAG": msdt.ResData = ERR_VALUE
        Case Else
            msdt.ResData = ERR_VALUE
    End Select

    On Error GoTo 0
    Exit Sub
ErrMeas:
    msdt.ResData = ERR_VALUE
    Resume Next

End Sub

'*************************
'   ̔
'   return : True  = PASS
'            False = FAIL
'*************************
Private Function MeasJudge(ByVal ch As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata) As Boolean

    With msi
        If .UpLmtLvl = 0 And .LwLmtLvl = 0 Then
            .passFlg = True
        Else
            .passFlg = True
            If .UpLmtLvlFlg And .UpLmtLvl < msdt.ResData Then .passFlg = False     'l`FbN
            If .LwLmtLvlFlg And msdt.ResData < .LwLmtLvl Then .passFlg = False     'l`FbN
        End If
        
        If .LwLmtFrqFlg Then If msdt.freq_lvl < .LwLmtFrq Then .passFlg = False
        If .UpLmtFrqFlg Then If .UpLmtFrq < msdt.freq_lvl Then .passFlg = False
        
        If .JudgeValid = BIS_OFF Then   '  = ̑荀
            .passFlg = True
        End If
        
        msdt.ResJudge = .passFlg        ' 茋

        MeasJudge = .passFlg
     End With

End Function

'**********************
' g[XEf[^擾
'**********************
Private Sub get_TraceData(ch As Long, chinf As struct_Chinfo)
    Dim lngErr As Long
    Dim lngMsrP As Long
        
    With chinf
        lngMsrP = .lngTotP - 1
        If (.WaveFrmt And WAVE_FORMAT_LOGMAG) = WAVE_FORMAT_LOGMAG Then
            lngErr = QryTracData(lngPID, .TrLgm, 0, lngMsrP, BufLgm(0, ch))  'LOGŨf[^ǂݏo܂
        End If
        If (.WaveFrmt And WAVE_FORMAT____SWR) = WAVE_FORMAT____SWR Then
            lngErr = QryTracData(lngPID, .TrLnm, 0, lngMsrP, BufLnm(0, ch))  'LINMAG̃f[^ǂݏo܂
            Call get_Swr(ch, 0, lngMsrP)
        End If
    End With

End Sub

'***************************
' Waveform display `FbN
'***************************
Private Sub Chk_TraceDraw_OnOff(ByVal ch As Long)

    If intFrmCh(ch) = 0 Then Exit Sub
    If frm_CH(ch).Check_TraceDraw.Value <> ChInfo(ch).intWaveDisp Then
        ChInfo(ch).intWaveDisp = frm_CH(ch).Check_TraceDraw.Value
        If ChInfo(ch).intWaveDisp = 0 Then
            frm_CH(ch).PictBox_Waveform.Cls     'g`\
            Call frm_CH(ch).ReDispResult        '荀ڍĕ\
        End If
    End If
End Sub

'*********************
' Cal ON/OFF `FbN
'*********************
Public Sub Chk_Cal_OnOff(ByVal ch As Long)
    Dim lngErr As Long
    
    If intFrmCh(ch) = 0 Then Exit Sub
    If frm_CH(ch).Check_cal.Value <> ChInfo(ch).Correct.CorOn Then
        If frm_CH(ch).Check_cal.Value = 1 Then
            lngErr = BisSensCorrCsetStat(lngPID, BIS_ON)
        Else
            lngErr = BisSensCorrCsetStat(lngPID, BIS_OFF)
        End If
        lngErr = QrySensCorrCsetStat(lngPID, ChInfo(ch).Correct.CorOn)
    End If
End Sub

'**********************
' Scale Enable Control
'**********************
Public Sub Scale_EnableCntrl(ByVal mx_ch As Long, ByVal bln As Boolean)
    Dim ch As Long
    
    For ch = ACT_CH1 To mx_ch
        frm_CH(ch).Combo_WaveFormat.Enabled = bln
        frm_CH(ch).Text_scl(0).Enabled = bln
        frm_CH(ch).Text_scl(1).Enabled = bln
        frm_CH(ch).Text_scl(2).Enabled = bln
        frm_CH(ch).Combo_SwrRef.Enabled = bln
        frm_CH(ch).Combo_SwrDiv.Enabled = bln
    Next ch
End Sub

'****************
' Auto Scale Set
'****************
Public Sub Set_Auto_Scale(ByVal ch As Long)
    Dim mx As Double
    Dim mn As Double
    Dim frq As Double
    Dim pt As Long
    Dim lngErr As Long
    Dim DispNo As Long
    Dim i As Integer
    
    If frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxLgm Then
        lngErr = QryFetcMax(lngPID, ChInfo(ch).TrLgm, 0, ChInfo(ch).lngTotP - 1, mx, frq, pt)
        lngErr = QryFetcMin(lngPID, ChInfo(ch).TrLgm, 0, ChInfo(ch).lngTotP - 1, mn, frq, pt)
        Call auto_scale(mx, mn, ChInfo(ch).Trace.Mscl)
        frm_CH(ch).Text_scl(0).Text = ChInfo(ch).Trace.Mscl.ref
        frm_CH(ch).Text_scl(1).Text = ChInfo(ch).Trace.Mscl.div
    ElseIf frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxSwr Then
        mx = CDbl(ChInfo(ch).Trace.MaxSwr)
        mn = CDbl(ChInfo(ch).Trace.MinSwr)
        Call auto_scale2(mx, mn, ChInfo(ch).Trace.SWRscl)
        i = get_unit_index(Math.Abs(ChInfo(ch).Trace.SWRscl.ref))
        frm_CH(ch).Text_scl(0).Text = chg_scale_unit(i, ChInfo(ch).Trace.SWRscl.ref)
        frm_CH(ch).Combo_SwrRef.ListIndex = i
        i = get_unit_index(ChInfo(ch).Trace.SWRscl.div)
        frm_CH(ch).Text_scl(1).Text = chg_scale_unit(i, ChInfo(ch).Trace.SWRscl.div)
        frm_CH(ch).Combo_SwrDiv.ListIndex = i
    End If
    
    If intFrmCh(ch) Then
        Call draw_waveO(ch, frm_CH(ch).PictBox_Waveform, ChInfo(ch).lngTotP, LimitFreqLvl(ch), DispNo)
    End If

    AutoScale(ch) = 0
End Sub

'*********************
' Auto Scale `FbN
'*********************
Public Sub Chk_Auto_Scale(ByVal ch As Long)
    Dim lngErr As Long
    
    If intFrmCh(ch) = 0 Then Exit Sub
End Sub

'************************
' | &  & g`\
'*************************
Public Function bna_test() As Boolean
    Dim lngErr As Long
    Dim blnjudg As Boolean
    Dim ch As Long
    Dim measct As Long
    Dim lngMsrP As Long
    Dim MeasNo As Long
    Dim MkrNo As Long
    Dim DispNo As Long
    Dim MeasFmt As String
    Dim jflg As Boolean
    Dim blnJudge As Boolean
    
    jflg = True
    MeasNo = 0
    MkrNo = 0
    DispNo = 0
    For ch = 0 To ChNum - 1                         '`l
        lngErr = meas_ch(ch)                        'SW-BOX ؂ւ
        Call Chk_Cal_OnOff(ch)
        Call Chk_TraceDraw_OnOff(ch)
        lngErr = BisInitImm(lngPID)                 '|Jn
        lngErr = BisInitWai(lngPID)                 '|I҂
        '*** g`f[^擾 ***
        Call get_TraceData(ch, ChInfo(ch))
        '*** ӏ̑ ***
        For measct = 0 To ChInfo(ch).MeasSegNum - 1  '荀ڐ
            MeasFmt = ChInfo(ch).trc(MeasInfo(ch, measct).RefFmtNo - 1).strFormat
            Call MeasExe(ch, MeasNo + 1, MeasInfo(ch, measct), MeasData(MeasNo), MeasFmt)
            blnJudge = MeasJudge(ch, MeasInfo(ch, measct), MeasData(MeasNo))
            If blnJudge = False Then jflg = False
            MeasNo = MeasNo + 1
        Next measct
        If intFrmCh(ch) Then
            ' *** g`\ ****
            If ChInfo(ch).intWaveDisp Then
                If AutoScale(lngACh) = 1 Then Call Set_Auto_Scale(ch)
                Call draw_waveO(ch, frm_CH(ch).PictBox_Waveform, ChInfo(ch).lngTotP, LimitFreqLvl(ch), MkrNo)
            Else
                frm_CH(ch).PictBox_Waveform.Cls
            End If
            ' *** 茋ʕ\ ***
            Call result_display(ch, frm_CH(ch).PictBox_Waveform, DispNo)
        End If
    Next ch
    ' ***  ****
    If jflg = True Then
        frmMain.Label_Judgment.Caption = "PASS"
        frmMain.Label_Judgment.BackColor = vbBlue
        bna_test = True
    Else
        frmMain.Label_Judgment.Caption = "FAIL"
        frmMain.Label_Judgment.BackColor = vbRed
        bna_test = False
'        Call Beep
    End If
   
End Function

'*****************
' CE[v
'*****************
Private Sub Main()
    Dim lngErr As Long
    Dim bln As Boolean
    
    MDIfrmMain.Show
    With frmMain
        Do      ''--------------------- Main Loop
            If ExitFlag = 1 Then        'TCP/IP Connect OFF?
                If lngPID Then
                    Call frmMain.unload_frmch
                    lngErr = BisClosePacket(lngPID)
                    lngPID = 0: ExitFlag = 0
                End If
            ElseIf ExitFlag = 2 Then    'frmMain [X]?
                If lngPID Then lngErr = BisClosePacket(lngPID)
                Exit Sub
            End If
            If ContFlag = 1 Then
                Do                      'A|
                    bln = bna_test()
                    DoEvents
                Loop While (ContFlag)
            End If
            DoEvents
        Loop While (1)  ''------------- Main Loop
    End With
    
End Sub

